import random
import time
from RPiKeyboardConfig import RPiKeyboardConfig

keyboard = RPiKeyboardConfig()

while True:
    # Generate a random number between 1 and 5
    random_number = random.randint(1, 5)
    print(f"Random number: {random_number}")
    
    # Only execute RGB code if the random number is 3
    if random_number == 3:
        # 1) Save the preset slot index
        current_idx = keyboard.get_current_preset_index()
        
        # 2) Switch to direct LED mode
        keyboard.set_led_direct_effect()
        
        # 3) Fill with random colours
        all_leds = keyboard.get_leds()
        for led in all_leds:
            h = random.randint(0, 255)
            s = 255
            v = 255
            keyboard.set_led_by_idx(idx=led.idx, colour=(h, s, v))
        keyboard.send_leds()
        
        # 4) Hold the flash
        time.sleep(1)
        
        # 5) Clear LEDs
        keyboard.rgb_clear()
        keyboard.send_leds()
        
        # 6) Restore preset
        if current_idx is not None:
            keyboard.set_current_preset_index(current_idx, save_index=False)
            print(f"Restored preset index {current_idx}")
    
    # Wait 1 second before next iteration
    time.sleep(1)